<?php

use Elementor\Group_Control_Css_Filter;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

class OSF_Elementor_Item_Box extends OSF_Elementor_Carousel_Base
{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'opal-item-box';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __('Opal Item Box', 'worldlife-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-image-box';
    }

    public function get_categories()
    {
        return array('opal-addons');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function _register_controls()
    {
        $this->start_controls_section(
            'section_item_box',
            [
                'label' => __('Item Box', 'worldlife-core'),
            ]
        );

        $repeater = new Elementor\Repeater();

        $repeater->add_control(
            'item',
            [
                'label' => __('Item Box Item', 'worldlife-core'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $repeater->add_control(
            'view',
            [
                'label' => __('View', 'worldlife-core'),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'traditional',
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'worldlife-core'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $repeater->add_control(
            'icon',
            [
                'label' => __('Choose Icon', 'worldlife-core'),
                'type' => Controls_Manager::ICON,
            ]
        );

        $repeater->add_control(
            'name',
            [
                'label' => __('Name', 'worldlife-core'),
                'default' => 'John Doe',
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'description',
            [
                'label' => __('Description', 'worldlife-core'),
                'default' => 'Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis.',
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => __('Link to', 'worldlife-core'),
                'placeholder' => __('https://your-link.com', 'worldlife-core'),
                'default' => [
                    'url' => '#',
                ],
                'type' => Controls_Manager::URL,
            ]
        );

        $this->add_control(
            'item_box_items',
            [
                'label' => __('Item Box Items', 'worldlife-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('Columns', 'worldlife-core'),
                'type' => Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_responsive_control(
            'gutter',
            [
                'label' => __('Gutter', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 60,
                    ],
                ],
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .column-item' => 'padding-left: calc({{SIZE}}{{UNIT}} / 2); padding-right: calc({{SIZE}}{{UNIT}} / 2);',
                    '{{WRAPPER}} .elementor-item-box-wrapper' => 'margin-left: calc({{SIZE}}{{UNIT}} / -2); margin-right: calc({{SIZE}}{{UNIT}} / -2);',
                ],
                'condition' => [
                    'enable_carousel!' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Text Alignment', 'worldlife-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'worldlife-core'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'worldlife-core'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'worldlife-core'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} ' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Carousel Option
        $this->add_control_carousel();

        // Wrapper
        $this->start_controls_section(
            'section_style_wrapper',
            [
                'label' => __('Wrapper', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'wrapper_margin',
            [
                'label' => __('Margin', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Image
        $this->start_controls_section(
            'section_style_image',
            [
                'label' => __('Image', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'image_spacing',
            [
                'label' => __('Spacing', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Icon
        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => __('Icon', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'size_icon',
            [
                'label' => __('Size', 'worldlife-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} i' => 'font-size: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_margin',
            [
                'label' => __('Margin', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_icon_style');

        $this->start_controls_tab(
            'tab_icon_normal',
            [
                'label' => __('Normal', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner:not(:hover) i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_icon_hover',
            [
                'label' => __('Hover', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'icon_color_hover',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner:hover i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Name
        $this->start_controls_section(
            'section_style_name',
            [
                'label' => __('Name', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_name',
                'selector' => '{{WRAPPER}} .elementor-item-box-name',
            ]
        );

        $this->start_controls_tabs('tabs_name_style');

        $this->start_controls_tab(
            'tab_name_normal',
            [
                'label' => __('Normal', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner:not(:hover) .elementor-item-box-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_name_hover',
            [
                'label' => __('Hover', 'worldlife-core'),
            ]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner:hover .elementor-item-box-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        // Description
        $this->start_controls_section(
            'section_style_description',
            [
                'label' => __('Description', 'worldlife-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_description',
                'selector' => '{{WRAPPER}} .elementor-item-box-description',
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label' => __('Color', 'worldlife-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner .elementor-item-box-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label' => __('Margin', 'worldlife-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .elementor-item-box-meta-inner .elementor-item-box-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $this->add_render_attribute('wrapper', 'class', 'elementor-item-box-wrapper');


        // Item
        $this->add_render_attribute('item', 'class', 'elementor-item-box-item');


        $this->add_render_attribute('meta', 'class', 'elementor-item-box-meta');


        //  class carousel
        if ($settings['enable_carousel'] === 'yes') {
            $this->add_render_attribute('row', 'class', 'owl-carousel owl-theme');
//            $carousel_settings = $this->get_carousel_settings();
//            var_dump($carousel_settings);
            $carousel_settings = array(
                'navigation' => $settings['navigation'],
                'autoplayHoverPause' => $settings['pause_on_hover'] === 'yes' ? 'true' : 'false',
                'autoplay' => $settings['autoplay'] === 'yes' ? 'true' : 'false',
                'autoplayTimeout' => $settings['autoplay_speed'],
                'items' => $settings['columns'],
                'items_tablet' => $settings['columns_tablet'],
                'items_mobile' => $settings['columns_mobile'],
                'loop' => $settings['infinite'] === 'yes' ? 'true' : 'false',

            );
            $this->add_render_attribute('row', 'data-settings', wp_json_encode($carousel_settings));
        } else {
            $this->add_render_attribute('row', 'class', 'row');
            $this->add_render_attribute('item', 'class', 'column-item');
            if (!empty($settings['columns'])) {
                $this->add_render_attribute('row', 'data-elementor-columns', $settings['columns']);
            }

            if (!empty($settings['columns_tablet'])) {
                $this->add_render_attribute('row', 'data-elementor-columns-tablet', $settings['columns_tablet']);
            }
            if (!empty($settings['columns_mobile'])) {
                $this->add_render_attribute('row', 'data-elementor-columns-mobile', $settings['columns_mobile']);
            }
        }

        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div <?php echo $this->get_render_attribute_string('row') ?>>
                <?php foreach ($settings['item_box_items'] as $index => $item) : ?>
                    <div <?php echo $this->get_render_attribute_string('item'); ?>>
                        <?php $this->render_style($item, $index, $settings) ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }

    protected function render_style($item, $index, $settings)
    {

        //Icon
        if (!empty($item['icon'])) {
            $element_icon = 'icon' . $index;
            $this->add_render_attribute($element_icon, 'class', $item['icon']);
            $this->add_render_attribute($element_icon, 'aria-hidden', 'true');
        }
        ?>

        <div class="elementor-item-box-meta-inner">
            <?php $this->render_image($settings, $item); ?>
            <div class="elementor-item-box-header">
                <?php if (!empty($item['icon'])) : ?>
                    <i <?php echo $this->get_render_attribute_string($element_icon); ?>></i>
                <?php endif; ?>

                <?php
                $item_box_name_html = $item['name'];
                if (!empty($item['link']['url'])) :
                    $item_box_name_html = '<a href="' . esc_url($item['link']['url']) . '">' . $item_box_name_html . '</a>';
                endif;
                ?>
                <div class="elementor-item-box-name"><?php echo $item_box_name_html; ?></div>
            </div>
            <?php if (!empty($item['description'])): ?>
                <div class="elementor-item-box-description"><?php echo $item['description'] ?></div>
            <?php endif; ?>
        </div>

        <?php
    }

    private function render_image($settings, $item)

    {
        ?>
        <div class="elementor-item-box-image">
            <?php
            $item['image_size'] = $settings['thumbnail_size'];
            $item['image_custom_dimension'] = $settings['thumbnail_custom_dimension'];
            if (!empty($item['image']['url'])) :
                $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'image');
                echo $image_html;
            endif;
            ?>
        </div>
        <?php
    }

}

$widgets_manager->register_widget_type(new OSF_Elementor_Item_Box());
