<?php

class OSF_WP_Widget_Recent_Posts extends WP_Widget_Recent_Posts {

    public function widget($args, $instance) {
        if (!isset($args['widget_id'])) {
            $args['widget_id'] = $this->id;
        }

        $title = (!empty($instance['title'])) ? $instance['title'] : __('Recent Posts', 'worldlife-core');

        $title = apply_filters('widget_title', $title, $instance, $this->id_base);

        $number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
        if (!$number) {
            $number = 5;
        }
        $show_date = isset($instance['show_date']) ? $instance['show_date'] : false;

        $r = new WP_Query(apply_filters('widget_posts_args', array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
        ), $instance));

        if (!$r->have_posts()) {
            return;
        }
        ?>
        <?php echo $args['before_widget']; ?>
        <?php
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        ?>
        <ul>
            <?php foreach ($r->posts as $recent_post) : ?>
                <?php
                $post_title = get_the_title($recent_post->ID);
                $title = (!empty($post_title)) ? $post_title : __('(no title)', 'worldlife-core');
                ?>
                <li class="item-recent-post">
                    <?php if (has_post_thumbnail($recent_post->ID)): ?>
                        <div class="thumbnail-post"><?php echo get_the_post_thumbnail($recent_post->ID, 'worldlife-thumbnail'); ?></div>
                    <?php endif; ?>
                    <div class="title-post">
                        <a href="<?php the_permalink($recent_post->ID); ?>"><?php echo $title; ?></a>
                        <?php if ($show_date) : ?>
                            <span class="post-date"><?php echo get_the_date('', $recent_post->ID); ?></span>
                        <?php endif; ?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
        <?php
        echo $args['after_widget'];
    }
}

class OSF_Event_Organizer_Widget extends WP_Widget {
    public function __construct() {
        $widget_ops = array(
            'classname'                   => 'osf_widget_event',
            'description'                 => __('Display Event Organizer', 'worldlife-core'),
            'customize_selective_refresh' => true,
        );
        parent::__construct('osf_widget_event_organizer', __('OSF Event Organizer', 'worldlife-core'), $widget_ops);
        $this->alt_option_name = 'osf_widget_event_organizer';
    }

    public function widget($args, $instance) {

        echo $args['before_widget'];

        ?>

        <div class="osf-event-items">
            <?php if (
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_phone')) ||
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_mail')) ||
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_web'))
            ): ?>
                <div class="osf-event-item">
                    <h2 class="osf-event-title widget-title">
                        <span><?php echo __('Organizer', 'worldlife-core'); ?></span>
                    </h2>
                    <div class="osf-event-content">
                        <ul>
                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_phone'))): ?>
                                <li>
                                    <span class="label"><?php echo __('Phone', 'worldlife-core'); ?></span>
                                    <div>
                                        <?php echo osf_get_metabox(get_the_ID(), 'osf_event_organizer_phone');
                                        ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_mail'))): ?>
                                <li>
                                    <span class="label"><?php echo __('Email', 'worldlife-core'); ?></span>
                                    <div>
                                        <?php echo osf_get_metabox(get_the_ID(), 'osf_event_organizer_mail');
                                        ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_organizer_web'))): ?>
                                <li>
                                    <span class="label"><?php echo __('Website', 'worldlife-core'); ?></span>
                                    <div>
                                        <?php echo osf_get_metabox(get_the_ID(), 'osf_event_organizer_web');
                                        ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
            <?php endif; ?>
        </div>
        <?php
        echo $args['after_widget'];
    }
}

class OSF_Event_Detail_Widget extends WP_Widget {
    public function __construct() {
        $widget_ops = array(
            'classname'                   => 'osf_widget_event',
            'description'                 => __('Display Event Detail', 'worldlife-core'),
            'customize_selective_refresh' => true,
        );
        parent::__construct('osf_widget_event_detail', __('OSF Event Detail', 'worldlife-core'), $widget_ops);
        $this->alt_option_name = 'osf_widget_event_detail';
    }

    public function widget($args, $instance) {

        echo $args['before_widget'];
        ?>

        <div class="osf-event-items">
            <div class="osf-event-item">
                <h2 class="osf-event-title widget-title"><span><?php echo __('Details', 'worldlife-core'); ?></span>
                </h2>

                <div class="osf-event-content">
                    <ul>
                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <li>
                                <span class="label"><?php echo __('Start', 'worldlife-core'); ?></span>
                                <div>
                                    <?php echo sprintf('<time class="entry-date" datetime="%1$s">%2$s</time>',
                                        date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date')),
                                        date('Y F, d', osf_get_metabox(get_the_ID(), 'osf_event_date'))
                                    );
                                    ?>
                                </div>

                            </li>
                        <?php endif; ?>

                        <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_date_end')) && !empty(osf_get_metabox(get_the_ID(), 'osf_event_date'))): ?>
                            <li>
                                <span class="label"><?php echo __('End', 'worldlife-core'); ?></span>
                                <div>
                                    <?php echo sprintf('<time class="entry-date" datetime="%1$s">%2$s</time>',
                                        date(DATE_W3C, osf_get_metabox(get_the_ID(), 'osf_event_date_end')),
                                        date('Y F, d', osf_get_metabox(get_the_ID(), 'osf_event_date_end'))
                                    );
                                    ?>
                                </div>
                            </li>
                        <?php endif; ?>
                        <li>
                            <span class="label"><?php echo __('Event Category', 'worldlife-core'); ?></span>
                            <div><?php the_terms(get_the_ID(), 'osf_event_category', '', ', ', '') ?></div>
                        </li>
                    </ul>

                </div>

            </div>
        </div>

        <?php
        echo $args['after_widget'];
    }
}

class OSF_Event_Venue_Widget extends WP_Widget {
    public function __construct() {
        $widget_ops = array(
            'classname'                   => 'osf_widget_event',
            'description'                 => __('Display Event Venue', 'worldlife-core'),
            'customize_selective_refresh' => true,
        );
        parent::__construct('osf_widget_event_venue', __('OSF Event Venue', 'worldlife-core'), $widget_ops);
        $this->alt_option_name = 'osf_widget_event_venue';
    }

    public function widget($args, $instance) {

        echo $args['before_widget'];
        ?>

        <div class="osf-event-items">
            <?php if (
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_add')) ||
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_phone')) ||
                !empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_web'))
            ): ?>
                <div class="osf-event-item">
                    <h2 class="osf-event-title widget-title"><span><?php echo __('Venue', 'worldlife-core'); ?></span>
                    </h2>

                    <div class="osf-event-content">
                        <ul>

                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_add'))): ?>
                                <li class="event_venue_add">
                                    <?php echo osf_get_metabox(get_the_ID(), 'osf_event_venue_add');
                                    ?>
                                </li>
                            <?php endif; ?>
                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_phone'))): ?>
                                <li>
                                    <span class="label"><?php echo __('Phone', 'worldlife-core'); ?></span>
                                    <div>
                                        <?php echo osf_get_metabox(get_the_ID(), 'osf_event_venue_phone');
                                        ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                            <?php if (!empty(osf_get_metabox(get_the_ID(), 'osf_event_venue_web'))): ?>
                                <li>
                                    <span class="label"><?php echo __('Website', 'worldlife-core'); ?></span>
                                    <div>
                                        <?php echo osf_get_metabox(get_the_ID(), 'osf_event_venue_web');
                                        ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>

                </div>
            <?php endif; ?>
        </div>

        <?php
        echo $args['after_widget'];
    }
}

function osf_widget_registration() {
    register_widget('OSF_WP_Widget_Recent_Posts');
    register_widget('OSF_Event_Detail_Widget');
    register_widget('OSF_Event_Organizer_Widget');
    register_widget('OSF_Event_Venue_Widget');
}

add_action('widgets_init', 'osf_widget_registration');